overall_rating();

function overall_rating() {
    let template = Template.GetCurrent();
    let models = ["M1", "T1"];

    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    for (let m of models) {
        let head_score = get_variable_value(status, `${m}_HEAD_FINAL_SCORE`, "float");
        let chest_score = get_variable_value(status, `${m}_CHEST_ABDOMEN_FINAL_SCORE`, "float");

        let total_score = head_score + chest_score;

        /** Check if capping limit is "TRUE" for any body region or head excursion zone
         * If it is then total score will automatically be zero. Add an asterisk to the score to indicate that it has been capped. */
        let overal_capping = "FALSE";
        for (let rep_var of Variable.GetAll(template)) {
            if (rep_var.name.endsWith("CAPPING_LIMIT") && rep_var.name.startsWith(`${m}_`) && rep_var.value == "TRUE") {
                total_score = "*0";
                overal_capping = "TRUE";
                break;
            }
        }

        /** create the "CAPPING_LIMIT" variable  */
        new Variable(template, `${m}_CAPPING_LIMIT`, "Capping Limit", overal_capping, "General", false, true);

        new Variable(
            template,
            `${m}_TOTAL_SCORE`,
            "head + chest & abdomen (0 if any capping limit is TRUE)",
            total_score,
            "General",
            false,
            true
        );
        new Variable(
            template,
            `${m}_MAX_POSSIBLE_SCORE`,
            "Maximum score for Far Side Assessment",
            "8",
            "General",
            false,
            true
        );
    }

    let sim_score = get_variable_value(status, "M1_TOTAL_SCORE", "float");
    let test_score = get_variable_value(status, "T1_TOTAL_SCORE", "float");
    let cfa = test_score / sim_score;
    if (cfa >= 0.9) {
        cfa = 1;
    }
    new Variable(template, "CFA", "Correlation Factor A", cfa.toString(), "General", false, true);

    /* Variables for use in summary template */
    let summary_head_score = get_variable_value(status, "T1_HEAD_FINAL_SCORE", "float");
    let summary_thorax_abdomen_score = get_variable_value(status, "T1_CHEST_ABDOMEN_FINAL_SCORE", "float");
    new Variable(
        template,
        "SUMMARY_HEAD_SCORE",
        "Head Score used in summary template",
        summary_head_score,
        "General",
        false,
        true
    );
    new Variable(
        template,
        "SUMMARY_THORAX_ABDOMEN_SCORE",
        "Thorax Abdomen Score used in summary template",
        summary_thorax_abdomen_score,
        "General",
        false,
        true
    );
    new Variable(template, "SUMMARY_TOTAL_SCORE", "Score used in summary template", test_score, "General", false, true);
}
